### Name: ccems-package
### Title: Combinatorially Complex Equilibrium Model Selection
### Aliases: ccems-package ccems
### Keywords: package

### ** Examples

library(ccems)
## this example corresponds to the reference above: dTTP induced R1 dimerization
topology <- list(  
        heads=c("R1t0","R2t0"),  
        sites=list(       
                s=list(                     # s-site    thread #
                        m=c("R1t1"),        # monomer      1
                        d=c("R2t1","R2t2")  # dimer        2
                )
        )
) 
g <- mkg(topology,TCC=TRUE) 
data(RNR)
d1 <- subset(RNR,(year==2001)&(fg==1)&(G==0)&(t>0),select=c(R,t,m,year))
d2 <- subset(RNR,year==2006,select=c(R,t,m,year)) 
dd <- rbind(d1,d2)
names(dd)[1:2] <- paste(strsplit(g$id,split="")[[1]],"T",sep="") # e.g. to form "RT"
rownames(dd) <- 1:dim(dd)[1] # lose big number row names of parent dataframe

## Note: This block is for a ROCKS cluster
cpusPerHost=c("localhost" = 4,"compute-0-0"=4,"compute-0-1"=4,"compute-0-2"=4)
chnkPs <- list(size=100,n=1,maxnPs=2,extend2maxP=TRUE)
## Not run: 
##D top10=ems(dd,g,cpusPerHost=cpusPerHost,chunkParams=chnkPs, ptype="SOCK") 
## End(Not run)
# The next example gives the cluster a really big (~12 hour) job
library(ccems)
topology <- list(
        heads=c("R1X0","R2X2","R4X4","R6X6"), # s-sites are already filled only in (j>1)-mer head nodes 
        sites=list(                    
                a=list(                                                              # a-site       thread #
                        m=c("R1X1"),                                                 # monomer          1
                        d=c("R2X3","R2X4"),                                          # dimer            2
                        t=c("R4X5","R4X6","R4X7","R4X8"),                            # tetramer         3
                        h=c("R6X7","R6X8","R6X9","R6X10", "R6X11", "R6X12")          # hexamer          4
                ),
                h=list( ## tails of a-site threads are heads of h-site threads       # h-site
                        m=c("R1X2"),                                                 # monomer          5
                        d=c("R2X5", "R2X6"),                                         # dimer            6
                        t=c("R4X9", "R4X10","R4X11", "R4X12"),                       # tetramer         7
                        h=c("R6X13", "R6X14", "R6X15","R6X16", "R6X17", "R6X18")     # hexamer          8
                )
        )
)
g=mkg(topology,TCC=TRUE) 
dd=subset(RNR,(year==2002)&(fg==1)&(X>0),select=c(R,X,m,year))
names(dd)[1:2]=paste(strsplit(g$id,split="")[[1]],"T",sep="") # e.g. c("RT","XT")

cpusPerHost=c("localhost" = 4,"compute-0-0"=4,"compute-0-1"=4,"compute-0-2"=4)
chnkPs <- list(size=1000,n=1,maxnPs=3,extend2maxP=TRUE) # 29 choose 3(2) is 3654(406), so 3654 + 406 + 29 + 1 = 4090 spurs 
## Not run: 
##D 
##D top10=ems(dd,g,cpusPerHost=cpusPerHost,chunkParams=chnkPs, ptype="SOCK") 
##D 
##D # The following are the last few lines of the output. The first line shows that the two parameter models are the best
##D # (shown are best AICs with increasing numbers of parameters). The next shows that it took 820 minutes on 16 cpus. 
##D # And the block that follows shows that the top 10 modes are all two parameter spur graph models. The html file 
##D # RXglobSOCK.htm in the results directory contains this information and more (e.g. parameter estimates and CI).
##D # Of the total number of models fitted reported in the html file, 4133, the difference 4133 - 4090 = 43 is the number of grid 
##D # models fitted. Grid models are always fitted as one batch before spur model fitting begins. 
##D 
##D [1]  41.14828  23.95284 -31.11051 -27.29232
##D Time difference of 819.9431 mins
##D 
##D  ... making HTML file ... 
##D   1 Model 252; nbp= 2; id=IIIIIIIJIIIJIIIIIIIIIIIIIIIII; AIC=-31.1105
##D   2 Model 187; nbp= 2; id=IIIIJIIIIIIIJIIIIIIIIIIIIIIII; AIC=-30.9837
##D   3 Model 186; nbp= 2; id=IIIIJIIIIIIJIIIIIIIIIIIIIIIII; AIC=-30.7098
##D   4 Model 163; nbp= 2; id=IIIJIIIIIIIIJIIIIIIIIIIIIIIII; AIC=-30.4086
##D   5 Model 232; nbp= 2; id=IIIIIIJIIIIIJIIIIIIIIIIIIIIII; AIC=-30.1868
##D 
##D > ## End(Not run)
## End(Not run)



