### Name: ems
### Title: Equilibrium Model Selection
### Aliases: ems
### Keywords: models

### ** Examples

library(ccems)
topology <- list(  
        heads=c("R1t0","R2t0"),  
        sites=list(       
                s=list(                     # s-site    thread #
                        m=c("R1t1"),        # monomer      1
                        d=c("R2t1","R2t2")  # dimer        2
                )
        )
) 
g <- mkg(topology,TCC=TRUE) 
data(RNR)
d1 <- subset(RNR,(year==2001)&(fg==1)&(G==0)&(t>0),select=c(R,t,m,year))
d2 <- subset(RNR,year==2006,select=c(R,t,m,year)) 
dd <- rbind(d1,d2)
names(dd)[1:2] <- paste(strsplit(g$id,split="")[[1]],"T",sep="") # e.g. to form "RT"
rownames(dd) <- 1:dim(dd)[1] # lose big number row names of parent dataframe
chnkPs <- list(size=4,n=1,maxnPs=1,extend2maxP=TRUE) # end sooner if maxnPs is reached, add chunks (i.e. increase n) if not
## The next line can be commented to speed up package check times.  
## Not run: 
##D  
##D top <- ems(dd,g,chunkParams=chnkPs)  # this takes roughly one minute 
## End(Not run)



