### Name: fitModel
### Title: Fit Model
### Aliases: fitModel
### Keywords: models

### ** Examples

library(ccems)
topology <- list(  
        heads=c("R1t0","R2t0"),  
        sites=list(       
                s=list(                     # s-site    thread #
                        m=c("R1t1"),        # monomer      1
                        d=c("R2t1","R2t2")  # dimer        2
                )
        )
) 
g <- mkg(topology,TCC=TRUE) 
data(RNR)
d1 <- subset(RNR,(year==2001)&(fg==1)&(G==0)&(t>0),select=c(R,t,m,year))
d2 <- subset(RNR,year==2006,select=c(R,t,m,year)) 
dRt <- rbind(d1,d2)
names(dRt)[1:2] <- paste(strsplit(g$id,split="")[[1]],"T",sep="") # e.g. to form "RT"
rownames(dRt) <- 1:dim(dRt)[1] # lose big number row names of parent dataframe

## Not run: 
##D models <- list(
##D        mkModel(g,"IIJJ",dRt,Kjparams=c(R2t0=Inf, R1t1=Inf,R2t1=1,   R2t2=1)), 
##D        mkModel(g,"IIIJ",dRt,Kjparams=c(R2t0=Inf, R1t1=Inf,R2t1=Inf, R2t2=1))
##D        )
##D fmodels <- lapply(models,fitModel) # a list of two models are fitted in series here on a single processor 
## End(Not run)
# Note that fitModel always delivers a summary of the fit to the screen as a byproduct. If no assignment is made, the returned large
# fitted list of models makes this summary time consuming to find (i.e. too much scrolling up). 



