### Name: mkGrids
### Title: Make Grid Model Space
### Aliases: mkGrids
### Keywords: models

### ** Examples

library(ccems)
topology <- list(  
        heads=c("R1t0","R2t0"),  
        sites=list(       
                s=list(                     # s-site    thread #
                        m=c("R1t1"),        # monomer      1
                        d=c("R2t1","R2t2")  # dimer        2
                )
        )
) 
g <- mkg(topology,TCC=TRUE) 
gridL <- mkGrids(g) 
print(gridL$chunk)

topology <- list(
        heads=c("R1X0","R2X2","R4X4","R6X6"), # s-sites are already filled only in (j>1)-mer head nodes 
        sites=list(                    
                a=list(                                                              # a-site       thread #
                        m=c("R1X1"),                                                 # monomer          1
                        d=c("R2X3","R2X4"),                                          # dimer            2
                        t=c("R4X5","R4X6","R4X7","R4X8"),                            # tetramer         3
                        h=c("R6X7","R6X8","R6X9","R6X10", "R6X11", "R6X12")          # hexamer          4
                ),
                h=list( ## tails of a-site threads are heads of h-site threads       # h-site
                        m=c("R1X2"),                                                 # monomer          5
                        d=c("R2X5", "R2X6"),                                         # dimer            6
                        t=c("R4X9", "R4X10","R4X11", "R4X12"),                       # tetramer         7
                        h=c("R6X13", "R6X14", "R6X15","R6X16", "R6X17", "R6X18")     # hexamer          8
                )
        )
)

g <- mkg(topology,TCC=TRUE) 
gridL <- mkGrids(g,maxnPs=2) 
print(gridL$chunk)

gridL <- mkGrids(g,maxnPs=4) 
# the next line should be uncommented and run separately from those above since its output is large. 
# print(gridL$chunk)



