### Name: mkKd2Kj
### Title: Make Kd2Kj Mappings
### Aliases: mkKd2Kj
### Keywords: models

### ** Examples

library(ccems)
topology <- list(  
        heads=c("R1t0","R2t0"),  
        sites=list(       
                s=list(                     # s-site    thread #
                        m=c("R1t1"),        # monomer      1
                        d=c("R2t1","R2t2")  # dimer        2
                )
        )
) 
g <- mkg(topology,TCC=TRUE) # generic model
gridL <- mkGrids(g,3)   
mkKd2Kj(gridL$g) # when there is only one function its name is "default"

topology <- list(
        heads=c("R1X0","R2X2","R4X4","R6X6"), # s-sites are already filled only in (j>1)-mer head nodes 
        sites=list(                    
                a=list(                                                              # a-site       thread #
                        m=c("R1X1"),                                                 # monomer          1
                        d=c("R2X3","R2X4"),                                          # dimer            2
                        t=c("R4X5","R4X6","R4X7","R4X8"),                            # tetramer         3
                        h=c("R6X7","R6X8","R6X9","R6X10", "R6X11", "R6X12")          # hexamer          4
                ),
                h=list( ## tails of a-site threads are heads of h-site threads       # h-site
                        m=c("R1X2"),                                                 # monomer          5
                        d=c("R2X5", "R2X6"),                                         # dimer            6
                        t=c("R4X9", "R4X10","R4X11", "R4X12"),                       # tetramer         7
                        h=c("R6X13", "R6X14", "R6X15","R6X16", "R6X17", "R6X18")     # hexamer          8
                )
        )
)

g <- mkg(topology,TCC=TRUE) 
gridL <- mkGrids(g,maxnPs=3)   
mkKd2Kj(gridL$g)  

## Not run: 
##D topology <- list(
##D         heads=c("R1X0","R2X0","R4X0","R6X0"), # no requirement that s-sites are filled in oligomers
##D         sites=list(                    
##D                 s=list(                                                              # s-site       thread #
##D                         m=c("R1X1"),                                                 # monomer          1
##D                         d=c("R2X1","R2X2"),                                          # dimer            2
##D                         t=c("R4X1","R4X2","R4X3","R4X4"),                            # tetramer         3
##D                         h=c("R6X1","R6X2","R6X3","R6X4", "R6X5", "R6X6")             # hexamer          4
##D                 ),
##D                 a=list(                                                              # a-site       thread #
##D                         m=c("R1X2"),                                                 # monomer          5
##D                         d=c("R2X3","R2X4"),                                          # dimer            6
##D                         t=c("R4X5","R4X6","R4X7","R4X8"),                            # tetramer         7
##D                         h=c("R6X7","R6X8","R6X9","R6X10", "R6X11", "R6X12")          # hexamer          8
##D                 ),
##D                 h=list( ## tails of a-site threads are heads of h-site threads       # h-site
##D                         m=c("R1X3"),                                                 # monomer          9
##D                         d=c("R2X5", "R2X6"),                                         # dimer            10
##D                         t=c("R4X9", "R4X10","R4X11", "R4X12"),                       # tetramer         11
##D                         h=c("R6X13", "R6X14", "R6X15","R6X16", "R6X17", "R6X18")     # hexamer          12
##D                 )
##D         )
##D )
##D 
##D g <- mkg(topology,TCC=TRUE) 
##D gridL <- mkGrids(g,maxnPs=3)   
##D mkKd2Kj(gridL$g)  
## End(Not run)




