### Name: mkModel
### Title: Make Specific Model
### Aliases: mkModel
### Keywords: models

### ** Examples

library(ccems)
topology <- list(  
        heads=c("R1t0","R2t0"),  
        sites=list(       
                s=list(                     # s-site    thread #
                        m=c("R1t1"),        # monomer      1
                        d=c("R2t1","R2t2")  # dimer        2
                )
        )
) 
g <- mkg(topology,TCC=TRUE) 

data(RNR)
dRt <- subset(RNR,(year==2001)&(fg==1)&(G==0)&(t>0),select=c(R,t,m,year))
names(dRt)[1:2] <- c("RT","tT") 

## first a simple spur model
mkModel(g,"IIIJ",dRt,Kjparams=c(R2t0=Inf, R1t1=Inf, R2t1=Inf, R2t2=1),indx=1)

## next three grid graphs
gridL <- mkGrids(g,3)
g <- gridL$g
chunk <- gridL$chunk
Keqs <- gridL$Keqs
Kmapping <- mkKd2Kj(g)
models <- NULL
mdlNames <- rownames(chunk)
for (j in mdlNames) models[[j]] <- mkModel(g=gridL$g,j,dRt,Kdparams=chunk[j,2:(g$nZ+1),drop=FALSE],
                        Keq=Keqs[[j]],Kd2KjLst=Kmapping,pparams=chunk[j,"p",drop=FALSE],indx=chunk[j,"indx"])
print(models[[3]])
print(chunk)




