### Name: simulateData
### Title: Simulate Data
### Aliases: simulateData
### Keywords: math

### ** Examples

library(ccems)
topology <- list(  
        heads=c("R1t0","R2t0"),  
        sites=list(       
                s=list(                     # s-site    thread #
                        m=c("R1t1"),        # monomer      1
                        d=c("R2t1","R2t2")  # dimer        2
                )
        )
) 
g <- mkg(topology,TCC=TRUE) 
model <- mkModel(g,"IIIJ",Kjparams=c(R1t1=Inf,R2t0=Inf, R2t1=Inf, R2t2=1))
phR <- .1
pht <- c(.1,.2,.5,1,2,5,10,20, 50)
physio <- data.frame(RT = rep(phR,length(pht)), tT = pht)
df <- simulateData(model,predict=physio,typeYP="m")$predict  
plot(df$tT,df$EY,type="l", log="x", xlab="[dTTP] (uM)", ylab="Mass (kDa)")



