### Name: ems
### Title: Equilibrium Model Selection
### Aliases: ems
### Keywords: models

### ** Examples

library(ccems)
topology <- list(  
        heads=c("R1t0","R2t0"),  
        sites=list(       
                s=list(                     # s-site    thread #
                        m=c("R1t1"),        # monomer      1
                        d=c("R2t1","R2t2")  # dimer        2
                )
        )
) 
g <- mkg(topology,TCC=TRUE) 
data(RNR)
d1 <- subset(RNR,(year==2001)&(fg==1)&(G==0)&(t>0),select=c(R,t,m,year))
d2 <- subset(RNR,year==2006,select=c(R,t,m,year)) 
dd <- rbind(d1,d2)
names(dd)[1:2] <- c("RT","tT")
rownames(dd) <- 1:dim(dd)[1] # lose big number row names of parent dataframe
# the call above ends sooner if maxTotalPs is reached
## Not run: 
##D  
##D top <- ems(dd,g,maxTotalPs=1)  # this takes roughly one minute 
## End(Not run)



