### Name: ccems-package
### Title: Combinatorially Complex Equilibrium Model Selection
### Aliases: ccems-package ccems
### Keywords: package

### ** Examples

## LAPTOP EXAMPLE: Top 3 three parameter models of 
##                 Berenstein et al. JBC 2000 TK1 data
library(ccems)
topology <- list(  
    heads=c("E1S0"), #one E is a tetramer
    sites=list(                    
        c=list(    # c-site = catyltic site  
            t=c("E1S1","E1S2","E1S3","E1S4")   
        )
    )
)
g <- mkg(topology,activity=TRUE,TCC=FALSE)
dd=subset(TK1,(year==2000),select=c(E,S,v)) # Berenstein et al
names(dd)[1:2]= c("ET","ST")
tops=ems(dd,g,maxTotalPs=3,kIC=30000) 
plot(dd$ST,dd$v,type="p",pch=1, xlab="[dT] (uM)", ylab="v",
          main="Top 3 TK1 Models with 3 parameters or less")
lgx=log(dd$ST)
upr=range(lgx)[2]
lwr=range(lgx)[1]
del=(upr-lwr)/50
fineX=exp(seq(lwr,upr,by=del))
newPnts <- data.frame(ET = rep(dd$ET[1],length(fineX)), ST = fineX)
for (i in 1:3) {
  df <- simulateData(tops[[i]],predict=newPnts,typeYP="v")$predict  
  lines(df$ST,df$EY,type="l",lty=i) 
}

## DESKTOP EXAMPLE: This example automatically creates (and fits) the model  
## space of the BMC SB 2008 dTTP induced R1 dimerization reference above.
library(ccems)
topology <- list(  
    heads=c("R1t0","R2t0"),  
    sites=list(       
        s=list(                     # s-site    thread #
            m=c("R1t1"),        # monomer      1
            d=c("R2t1","R2t2")  # dimer        2
        )
    )
) 

g <- mkg(topology,TCC=TRUE) 
data(RNR)
d1 <- subset(RNR,(year==2001)&(fg==1)&(G==0)&(t>0),select=c(R,t,m,year))
d2 <- subset(RNR,year==2006,select=c(R,t,m,year)) 
dd <- rbind(d1,d2)
names(dd)[1:2] <- paste(strsplit(g$id,split="")[[1]],"T",sep="")#e.g. to form "RT"
rownames(dd) <- 1:dim(dd)[1] # lose big number row names of parent dataframe
## top10=ems(dd,g,cpusPerHost=c("localhost"=2),maxTotalPs=2,ptype="SOCK") 

## CLUSTER EXAMPLE: This ATP induced R1 hexamerization example runs 1.8 days
##                  on a 16 core (4 quad proc machines) ROCKS Linux cluster. 

library(ccems)
topology <- list(
    heads=c("R1X0","R2X2","R4X4","R6X6"), 
    sites=list(                # s-sites are already filled only in (j>1)-mers 
        a=list(  #a-site                                                    thread
            m=c("R1X1"),                                            # monomer   1
            d=c("R2X3","R2X4"),                                     # dimer     2
            t=c("R4X5","R4X6","R4X7","R4X8"),                       # tetramer  3
            h=c("R6X7","R6X8","R6X9","R6X10", "R6X11", "R6X12")     # hexamer   4
        ), # tails of a-site threads are heads of h-site threads
        h=list(   # h-site
            m=c("R1X2"),                                            # monomer   5
            d=c("R2X5", "R2X6"),                                    # dimer     6
            t=c("R4X9", "R4X10","R4X11", "R4X12"),                  # tetramer  7
            h=c("R6X13", "R6X14", "R6X15","R6X16", "R6X17", "R6X18")# hexamer   8
        )
    )
)
g=mkg(topology,TCC=TRUE) 
dd=subset(RNR,(year==2002)&(fg==1)&(X>0),select=c(R,X,m,year))
names(dd)[1:2] <- paste(strsplit(g$id,split="")[[1]],"T",sep="")#i.e. c("RT","XT")

## 29 choose 3(2) is 3654(406), so 3654 + 406 + 29 + 1 = 4090 spurs, but after 
## subtracting those without at least one hexamer complex, and after adding 
## grids, the total number of models is 3410. Of these 3406 converged, see below. 
## Not run: 
##D cpusPerHost=c("localhost" = 4,"compute-0-0"=4,"compute-0-1"=4,"compute-0-2"=4)
##D top10=ems(dd,g,cpusPerHost=cpusPerHost, maxTotalPs=3, ptype="SOCK",IC=100) 
##D 
##D # The following are the last few lines of the output. The first line shows that a 
##D # one parameter model is best(shown are best AICs of models with 0, 1, 2 or 3  
##D # parameters). The next shows that it took 1.8 days on 16 cpus to fit 3406 models. 
##D # And the block that follows shows that the top 5 models are all spur graph models.
##D # The html file RXglobSOCK.htm in the results directory contains this information 
##D # and more (e.g. parameter estimates and CI). 
##D #
##D # [1] 1000000.00000     -33.16309     -31.73658     -29.99075
##D #
##D # Time difference of 2623.881 mins
##D # Fitted = 3406, out of a total of  3410 
##D #
##D # ... making HTML file ... 
##D #  1 Model  20; nbp= 1; id=IIIIIIIIIIIJIIIIIIIIIIIIIIIII; AIC=-33.1631
##D #  2 Model 108; nbp= 2; id=IIIIIJIIIIIJIIIIIIIIIIIIIIIII; AIC=-31.7366
##D #  3 Model  21; nbp= 1; id=IIIIIIIIIIIIJIIIIIIIIIIIIIIII; AIC=-31.5144
##D #  4 Model 109; nbp= 2; id=IIIIIJIIIIIIJIIIIIIIIIIIIIIII; AIC=-31.4678
##D #  5 Model 145; nbp= 2; id=IIIIIIIIJIIIJIIIIIIIIIIIIIIII; AIC=-31.4431
## End(Not run)



