### Name: mkModel
### Title: Make Specific Model
### Aliases: mkModel
### Keywords: models

### ** Examples

library(ccems)
topology <- list(  
        heads=c("R1t0","R2t0"),  
        sites=list(       
                s=list(                     # s-site    thread #
                        m=c("R1t1"),        # monomer      1
                        d=c("R2t1","R2t2")  # dimer        2
                )
        )
) 
g <- mkg(topology,TCC=TRUE) 

data(RNR)
dRt <- subset(RNR,(year==2001)&(fg==1)&(G==0)&(t>0),select=c(R,t,m,year))
names(dRt)[1:2] <- c("RT","tT") 

## first a simple spur model
mkModel(g,"IIIJ",dRt,Kjparams=c(R2t0=Inf, R1t1=Inf, R2t1=Inf, R2t2=1))
Kmapping=mkKd2Kj(g)
mdl=mkModel(g,"HDFF",dRt,Kdparams=c(R2t0=1, R0t0_t=1, R2t0_t=1, R2t1_t=1), 
                  Keq=c(R2t1_t="R2t0_t"),Kd2KjLst=Kmapping) 
fmdl <- fitModel(mdl)

## or mkGrids can be used to achieve the same thing as follows
gridL <- mkGrids(g,maxTotalPs=3)
chunk <- gridL$chunk
Keqs <- gridL$Keqs
mdl <- mkModel(g,"HDFF",dRt,Kdparams=chunk["HDFF",2:(g$nZ+1)], Keq=Keqs[["HDFF"]], Kd2KjLst=Kmapping,
       pparams=chunk["HDFF","p",drop=FALSE],indx=chunk["HDFF","indx"])
print(mdl)
print(chunk)
print(Keqs)




