### Name: TK1
### Title: Thymidine Kinase 1 Data
### Aliases: TK1
### Keywords: datasets

### ** Examples


## Note that two windows devices will end up exactly on top of each other. 
## Please move device 3 below device 2 to compare their residual plots. 
library(ccems)
## Warning: the next line clears all existing figures!!
if (!is.null(dev.list())) for (i in 2:max(dev.list())) dev.off(i);
for (j in 1:2) {
  if (.Platform$OS.type=="windows") 
    windows(width = 10, height = 4,restoreConsole = TRUE,
    ypos=ifelse(j==2,-50,0)) else X11(width=10,height=4)
  par(mfcol=c(2,5),mar=c(4,4,2,1)+.1)
  for (i in 1:5) {
    d=subset(TK1,index==i,select=c(E,S,k,frstAut,year))
    if (j==1) 
      hillda<-nls(k~kmax*(S/S50)^h/(1+(S/S50)^h),d,start=list(kmax=5,S50=1,h=1))
    if (j==2) 
      hillda<-nls(k~kmax*(S/S50)^h/(1+(S/S50)^h),d,
                  start=list(kmax=5,S50=1,h=1),weights=1/k^2)
    print(hillda)
    plot(d$S,d$k,xlab="Total [dT]",log="xy", ylab="k (1/sec)", 
        main=paste(d[1,"frstAut"],d[1,"year"]))
    mtext(paste("N =",length(d$k)),line=-3,side=1,font=1,cex=0.7)
    mtext(paste("Hill Coeff = ",format(hillda$m$getPars()["h"],digits=3),sep="")
           ,line=-2,side=1,font=1,cex=0.7)
    ## Note that the specific activity is ~16 fold higher in non-Birringer data
    lgx=log(d$S)
    upr=range(lgx)[2]
    lwr=range(lgx)[1]
    del=(upr-lwr)/50
    fineX=exp(seq(lwr,upr,by=del))
    lines(fineX,predict(hillda,list(S=fineX)),col="black",lwd=1)
    plot(hillda$m$fitted(),hillda$m$resid(),xlab="Fitted Value",
        ylab="Residual",mar=c(2,2,0,1)+.1)
    ## Note that variance increases with the mean in non-Birringer data
    ## and that the 2000 and 1993 Hill fits are poor at low k (and [S])
  }
}

## Not run: 
##D if (.Platform$OS.type=="windows")  # now create a window for ccems fits 
##D  windows(width = 10, height = 4,restoreConsole = TRUE, ypos=50) else 
##D          X11(width=10,height=4)
##D library(ccems)
##D topology <- list(  
##D     heads=c("E1S0"), # E1S0 = substrate free E
##D     sites=list(                    
##D         c=list(    # c for catalytic site  
##D             t=c("E1S1","E1S2","E1S3","E1S4")   
##D         ) # t for tetramer 
##D     )
##D )   # in transform below, TK1 is 25kDa => 25mg/umole
##D g <-mkg(topology, activity=TRUE,TCC=FALSE)
##D 
##D getKk <- function(x) {t(x$report[c(paste("E1S",0:3,"_S",sep=""),
##D                        paste("kE1S",1:4,sep="")),"final",drop=FALSE])}
##D getAIC <- function(x) { x$report["AIC","final"]}
##D getSSE <- function(x) { x$report["SSE","final"]}
##D outs=list(NULL)
##D par(mfcol=c(2,5),mar=c(4,4,2,1)+.1)
##D for (i in 1:5) {
##D d=subset(TK1,index==i,select=c(E,S,k,frstAut,year))
##D plot(d$S,d$k,xlab="Total [dT]",log="xy", ylab="k (1/sec)", 
##D          main=paste(d[1,"frstAut"],d[1,"year"]))
##D names(d)[1:2]= c("ET","ST")
##D tops=ems(d,g,maxTotalPs=3,doSpurs=FALSE)# takes ~15 sec for each dataset
##D lgx=log(d$ST)
##D upr=range(lgx)[2]
##D lwr=range(lgx)[1]
##D del=(upr-lwr)/50
##D fineX=exp(seq(lwr,upr,by=del))
##D predict <- data.frame(ET = rep(d$ET[1],length(fineX)), ST = fineX)
##D df <- simulateData(tops[[1]],predict=predict,typeYP="k")$predict  
##D lines(df$ST,df$EY) 
##D Kk=lapply(tops,getKk)
##D nms=names(Kk)
##D rowList=data.frame(NULL)
##D for (j in nms) {
##D     rowList=rbind(rowList,Kk[[j]])
##D   }
##D rownames(rowList)<-nms
##D aic=sapply(tops,getAIC)
##D sse=sapply(tops,getSSE)
##D eDelAIC=exp(-(aic-min(aic)))
##D wgts=eDelAIC/sum(eDelAIC)
##D print(sum(wgts))
##D df=data.frame(aic,sse,wgts,rowList)
##D M=as.matrix(rowList)
##D ma=exp(wgts%*%log(M)) # average in space of gibbs free energy changes
##D dataID=paste(d[1,"frstAut"],d[1,"year"],sep="")
##D outs[[dataID]]$df=df
##D outs[[dataID]]$ma=ma
##D plot(tops[[1]]$d$EY,tops[[1]]$res,xlab="Fitted Value",
##D                ylab="Residual",main=tops[[1]]$mid)
##D ## Note that the 2000 and 1993 fits are now improved 
##D }
##D outs=outs[-1] # remove leading NULL
##D print(outs)   # compare model averages across datasets
##D par(mfrow=c(1,1))
## End(Not run)  




