### Name: simulateData
### Title: Simulate Data
### Aliases: simulateData
### Keywords: math

### ** Examples

library(ccems)
topology <- list(  
        heads=c("R1t0","R2t0"),  
        sites=list(       
                s=list(                     # s-site    thread #
                        m=c("R1t1"),        # monomer      1
                        d=c("R2t1","R2t2")  # dimer        2
                )
        )
) 
g <- mkg(topology,TCC=TRUE) 
d=subset(RNR,(year==2001)&(fg==1)&(t>0)&(G==0),select=c(R,t,m,year))
names(d)[1:2] <-c("RT","tT") 
mdl=mkModel(g,"IIIJ",d,Kjparams=c(R2t0=Inf, R1t1=Inf,R2t1=Inf, R2t2=1),
                     pparams=c(p=1))
fmdl <- fitModel(mdl)
pt=c(.1,1:20)
predict <- data.frame(RT = rep(7.6,length(pt)), tT = pt)
df <- simulateData(fmdl,predict=predict,typeYP="m")$predict  
plot(d$tT,d$m,type="p",  xlab="[dTTP] (uM)", ylab="Weight averaged R1 mass", 
     main="Scott et al. Biochemistry, 2001, Fig. 1 (DLS data)")
lines(df$tT,df$EY) 




