rm(list=ls(all=TRUE))  # clean up left overs from previous run, though shouldn't need to.
if (.Platform$OS.type=="windows") home="/users/radivot" else home="/home/radivot"
setwd(home)  # place where models and results will go
source(paste(home,"/start.r",sep=""))  # define host="machineName" in this file
if (0) library(ccems) else { # if 0 source in the package to save install time 
  pkgNms=dir(paste(home,"/case/active/ccems/ccems/R",sep=""),full.names=TRUE)
  for (i in pkgNms) source(i)  # source in all of the R files of the package
  load(paste(home,"/case/active/papers/TK1/data/TK1.rda",sep=""))
}

topology <- list(  
    heads=c("E1S0"), # E1S0 = substrate free E
    sites=list(                    
        c=list(    # c for catalytic site  
            t=c("E1S1","E1S2","E1S3","E1S4")   
        ) # t for tetramer 
    )
)   # in transform below, TK1 is 25kDa => 25mg/umole
g <-mkg(topology, activity=TRUE,TCC=FALSE,doSqrt=TRUE)


KS=c("E1S0_S","E1S1_S","E1S2_S","E1S3_S")
kS=c("kE1S1","kE1S2","kE1S3","kE1S4")


## Warning: the next line clears all existing figures!!
if (!is.null(dev.list())) for (i in 2:max(dev.list())) dev.off(i);

if (.Platform$OS.type=="windows")  # now create a window for ccems fits 
  windows(width = 10, height = 2,restoreConsole = TRUE) else X11(width=10,height=2)
par(mfcol=c(1,5),mar=c(4,4,2,1)+.1)
load("case/results/outs")

doAICS=FALSE
modAve=TRUE
boxCox=FALSE
kill3=TRUE
kill1=TRUE

options(stringsAsFactors = FALSE)
mymins=list(NULL)
for (i in 1:5) {
  d=subset(TK1,index==i,select=c(E,S,k,frstAut,year)) # needed only to get titles in plot in next line
  if ((i==1)&(kill3)) d=d[-(14:16),]
  if ((i==3)&(kill1)) d=d[-1,]
  print(d)
  with(outs[[i]]$df,plot(numP,sse,log="y",ylab="SSE",xlab="Number of Parameters",main=paste(d[1,"frstAut"],d[1,"year"])))
  print(outs[[i]]$df[1:4,])
  outs[[i]]$df=data.frame(outs[[i]]$df,names=rownames(outs[[i]]$df))
  if (i==5) outs[[i]]$df=subset(outs[[i]]$df,subset=numP<7)  # trim neg correction denoms for model averages below
  minmod<-outs[[i]]$df[which(outs[[i]]$df$sse==min(outs[[i]]$df$sse)),]
  if (doAICS) minmod<-outs[[i]]$df[which(outs[[i]]$df$aic==min(outs[[i]]$df$aic)),]
  mymins=rbind(mymins,minmod)
}
mymins

boxcox<-function(yin,lam=0.5) {
  gm=prod(yin)^(1/length(yin))
  if (lam==0) yout=log(yin)/gm  else
    yout=(yin^lam-1)/(lam*gm^(lam-1))
  yout
}


if (.Platform$OS.type=="windows")  # now create a window for ccems fits 
  windows(width = 12.5, height = ifelse(boxCox,10,5),restoreConsole = TRUE,ypos=-25) else X11(width=12.5,height=5)
par(mfcol=c(ifelse(boxCox,4,2),5),mar=c(4,4,2,1)+.1)

for (i in 1:5) {
  d=subset(TK1,index==i,select=c(E,S,k,frstAut,year))
  if ((i==1)&(kill3)) d=d[-(14:16),]
  plot(d$S,d$k,xlab="Total [dT]",log="xy", ylab="k (1/sec)", 
      main=paste(d[1,"frstAut"],d[1,"year"]))
  names(d)[1:2]= c("ET","ST")
  lgx=log(d$ST)
  upr=range(lgx)[2]
  lwr=range(lgx)[1]
  del=(upr-lwr)/50
  fineX=exp(seq(lwr,upr,by=del))
  predict <- data.frame(ET = rep(d$ET[1],length(fineX)), ST = fineX)
  Keq=NULL;keq=NULL
  nm=mymins[i,"names"]
  if (modAve) {  Keq=NULL; keq=NULL; nm="Model Average"}
  Kmapping=mkKd2Kj(g)
  Kic=mymins[i,KS,drop=FALSE]
  if (modAve) Kic=outs[[i]]$ma[1:4]
  names(Kic)<-KS
  kic=mymins[i,kS,drop=FALSE]
  if (modAve) kic=outs[[i]]$ma[,5:8]
  names(kic)<-kS
  mdl=mkModel(g,nm,d,Kdparams=Kic, Kd2KjLst=Kmapping,kparams=kic)
  df <- simulateData(mdl,predict=predict,typeYP="k")$predict  
  smdl <- simulateData(mdl,init=TRUE)  
  fmdl=smdl
  lines(df$ST,df$EY) 
  options(digits=2)
  Kstrn="         K = "
  for (j in KS) 
    Kstrn=paste(Kstrn,sprintf("%3.2f",Kic[j]),sep=ifelse(j!="E1S0_S",", ",""))
  Kstrn 
  kstrn="         k = "
  for (j in kS) 
    kstrn=paste(kstrn,sprintf("%3.2f",kic[j]),sep=ifelse(j!="kE1S1",", ",""))
  kstrn
  mtext(Kstrn,line=-2,side=1,font=1,cex=0.6)
  mtext(kstrn,line=-3,side=1,font=1,cex=0.6)
#  mtext(paste("N = ",length(d$k),", P = ",mymins[i,"numP"],sep=""),line=-4,side=1,font=1,cex=0.7)
  plot(fmdl$d$EY,fmdl$res,xlab="Fitted Value",ylab="Residual",main=fmdl$mid)
  if (boxCox){
    res=boxcox(fmdl$d$k,lam)-boxcox(fmdl$d$EY,lam)
    plot(boxcox(fmdl$d$EY,lam),res,xlab="Fitted Value",ylab="Residual",main=fmdl$mid)
    res=boxcox(fmdl$d$k,-lam)-boxcox(fmdl$d$EY,-lam)
    plot(boxcox(fmdl$d$EY,-lam),res,xlab="Fitted Value",ylab="Residual",main=fmdl$mid)
  }
  
  
}



#dev.copy2pdf(file="results/hillFit.pdf")


