library(ccems)
if (!is.null(dev.list())) for (i in 2:max(dev.list())) dev.off(i);
windows(width = 8, height = 4,restoreConsole = TRUE,ypos=0)
dk=subset(RNR,(year==2002)&(fg==7)&(C>0)&(v>0)&(X<3200),select=c(R,r,C,X,v,year))
par(mfcol=c(1,1),mar=c(4.2,4,1,0)+.1)
with(dk,plot(X,v,log="",ylab="CDP Reductase Activity (1/sec)",xlab="[ATP] in uM",xlim=c(0,3000)))


# NOTE: the mass does not reach 540 and this may be problematic  ... skip the mass data
windows(width = 8, height = 8,restoreConsole = TRUE,ypos=0)
par(mfcol=c(2,1),mar=c(4.2,4,1,0)+.1,oma=c(0,0,1,0))

dk=subset(RNR,(year==2002)&(fg==7)&(C>0)&(v>0)&(X<3300),select=c(R,r,C,X,v,year))
with(dk,plot(X,v,log="",ylab="CDP Reductase Activity (1/sec)",xlab="[ATP] in uM",xlim=c(0,3300)))

dm=subset(RNR,(year==2002)&(fg==7)&(C>0)&(m>0)&(X<3300),select=c(R,r,C,X,m,year))
with(dm,plot(X,m,log="",ylab="R1 mass (kDa)",xlab="[ATP] in uM",xlim=c(0,3300)))
