getEk<-function(g,init=FALSE){ 
  if (sum(g$params[,"constr"]!="none")>0) {
    bound=row.names(g$params)[g$params[,"constr"]!="none"]  # bound = follower, free = leader
    free=g$params[bound,"constr"] # these are the free params to which the bound ones are bound
    g$params[bound,"final"]=g$params[free,"final"]
  }
  Pframe=as.data.frame(t(g$params[,"final",drop=F]))
  N=g$nData=dim(g$d)[1]
  attach(Pframe)
  attach(g$d)
  for (j in 1:N){
    X=XT[j]
    Rpoly = c(-RT[j], 1, 2*(1/K0 + X^i1/K1^(i1+1)),0,0,0,6*(X^i2/K2^(i2+5) + X^i3/K3^(i3+5)))  
    Rpoly = as.polynom(Rpoly)
    e=try(rts <- solve(Rpoly))
    R <- Re(rts[(Mod(Im(rts)) < 1e-06) & (Re(rts) > 0)])
    Z0=R^2/K0 
    Z1=R^2*X^i1/K1^(i1+1)
    Z2=R^6*X^i2/K2^(i2+5)
    Z3=R^6*X^i3/K3^(i3+5)
    g$d$Ek[j]=(2*k0*Z0+2*k1*Z1+6*k2*Z2+6*k3*Z3)/RT[j]
    g$d$RQ[j]=R+2*Z0+2*Z1+6*Z2+6*Z3
    g$d$R[j]=R
  }
  detach(Pframe)
  detach(g$d)
  SSE=sum((g$d$Ek-g$d$k)^2)
  P=sum(g$params[,"opt"]) + 1 # include the variance
  aic=N*log(SSE/N)+2*P + 2*P*(P+1)/(N-P-1) + N*log(2*pi) + N
  if (P>=N-1) aic=Inf
  if (init) {
    g$SSE$initial=SSE 
    g$AIC$initial = aic
  } 
  g$SSE$final=SSE 
  g$AIC$final =  aic
  g
}


fitModel <- function(model) {
  
  fopt <- function(pars,model) {
    pars=exp(pars)
    model$params[names(pars),"final"]=pars  
    model=getEk(model)
    return(model$SSE$final)   
  }
  
  p0=t(model$params[model$params[,"opt"],"initial",drop=F])
  p0=unlist(as.data.frame(p0))
  if ((model$nOptParams<-length(p0))>0) {                    
    p0=sapply(p0,log)
    p0<-gafit(fopt,p0,model=model)
    print(p0)
#    if (model$nOptParams>1) opt<-optim(p0,fopt,method="BFGS",hessian=TRUE,model=model,control=list(trace=F,maxit=5000)) else
#                            opt<-optim(p0,fopt,method="BFGS",hessian=TRUE,model=model,control=list(trace=F));       
  }
  opar<-exp(opt$par)
  model$params[names(opar),"final"]=opar  
  model=getEk(model)
  sg<-sqrt(opt$value/(model$nData-model$nOptParams))
  if (det(opt$hessian)>0) 
  {sig=sg*sqrt(diag(solve(opt$hessian/2)))
    upper=signif(opt$par+1.96*sig,3)
    lower=signif(opt$par-1.96*sig,3)
    CI=cbind(lower,upper)
    model$CI=exp(CI); 
    model$hess=TRUE} else
  {model$hess=FALSE} 
  model
#  opt
}

plotg<-function(g,kill=FALSE){
  Xg <- c(seq(0,400,by=25),seq(400,3000,by=100)) 
  id=g$id
  pd=data.frame(RT=1.2, XT=Xg)
  nX=length(Xg)
  pg=g
  pg$d=pd
  pg=getEk(pg)
  pd=pg$d
  d=g$d
  if (kill) if (!is.null(dev.list())) for (i in 2:max(dev.list())) dev.off(i);
  windows(width = 8, height = 4,restoreConsole = TRUE,ypos=0)
  par(mar=c(4.2,4,0,1)+.1,oma=c(0,0,3,1))
  with(d,plot(XT,k,ylim=c(.1,.3),ylab="CDP Reductase Activity (1/sec)",xlab="[ATP] in uM"))
  with(pd,lines(XT,Ek))
  SSE=g$SSE$final
  AICc=signif(g$AIC$final,3) 
  P=sum(g$params[,"opt"]) + 1 # include the variance
  SSE=format(SSE,digits=3)
  title(paste(id," (AIC=",AICc,", SSE=",SSE,")",sep=""),outer=TRUE,line=1.7,cex.main=1)
  title(paste(row.names(g$params),"=",format(g$params[,"final"],digits=2,trim=T,
              nsmall=0,scientific=FALSE),sep="",collapse=";  "), outer=TRUE,line=.7,cex.main=0.8)
}
