rm(list=ls(all=TRUE))  # clean up left overs from previous run, though shouldn't need to.
# This code is meant to be run on a ROCKS 5.1 cluster
if (.Platform$OS.type=="windows") home="/users/radivot" else home="/home/radivot"
source(paste(home,"/start.r",sep=""))  # define host="machineName" in this file
setwd(home)  # place where models and results will go
if (0) library(ccems) else { # if 0 source in the package 
  pkgNms=dir(paste(home,"/case/active/ccems/ccems/R",sep=""),full.names=TRUE)
  for (i in pkgNms) source(i)  # source in all of the R files of the package
  RNR=read.table(file=paste(home,"/case/active/rnr/datasets/RNR.txt",sep=""),header=TRUE)
}
d=subset(RNR,(year==2002)&(fg==7)&(C>0)&(v>0)&(X<3200),select=c(R,r,C,X,v,year))
d=transform(d,k=v)
names(d)[c(1,4)]=c("RT","XT")
dim(d)
d=d[order(d$XT),]
options(stringsAsFactors = FALSE)
library(PolynomF)
library(snow)
source(paste(home,"/case/active/ccems/ccems/inst/papers/RXC/commonRXC.R",sep=""))
g=NULL
g$d=d
cnt=0
G=NULL
for (j1 in 1:5) 
  for (j2 in (3*j1):17) 
    for (j3 in (j2+1):18){
      cnt=cnt+1
      cat("count is ",cnt,"\n")                                                          # break
#      s=c(i1=j1,i2=j2,i3=j3,k0=0.29,k1=0.29,k2=0.0,k3=0.29,K0=3.3,K1=6.7,K2=10,K3=100) # 1 129   K3=200 => 67; K3 = 60 => 136; 20=> error 
#      s=c(i1=j1,i2=j2,i3=j3,k0=0.29,k1=0.29,k2=0.0,k3=0.29,K0=3.5,K1=10,K2=20,K3=60)  # 2  118
#      s=c(i1=j1,i2=j2,i3=j3,k0=0.29,k1=0.29,k2=0.0,k3=0.29,K0=3.5,K1=13,K2=15,K3=60)  # 3  115
      s=c(i1=j1,i2=j2,i3=j3,k0=0.29,k1=0.29,k2=0.0,k3=0.29,K0=3.3,K1=6.7,K2=10,K3=60) # 
#       s=c(i1=j1,i2=j2,i3=j3,k0=0.29,k1=0.29,k2=0.0,k3=0.29,K0=3.5,K1=20,K2=15,K3=60)  # worse, breakpoint at 87
#       s=c(i1=j1,i2=j2,i3=j3,k0=0.29,k1=0.29,k2=0.0,k3=0.29,K0=3.5,K1=15,K2=15,K3=60)  # this caused an error
      g$params=data.frame(initial=s,final=s,opt=TRUE,constr="none")
      g$params[c(1:3,5:7),"opt"]=FALSE
      g$params[c(5,7),"constr"]="k0"
      g$id=paste(j1,j2,j3,sep=".")
      g=getEk(g,init=TRUE)
      G[[cnt]]=g
    }
cnt
#print(sapply(G,function(x) x$d$RQ))

names(G)<-sapply(G,function(x) x$id)
ptype="SOCK"
t0 = Sys.time();      
if (host=="ATP") ptype=""
if (ptype=="SOCK") {
  bigNms=c("localhost")
  rackLen=c(12,12)
  for (rack in 0:1) for (node in 0:rackLen[rack+1])  bigNms=c(bigNms,paste("compute",rack,node,sep="-"))
  big=rep(4,length(bigNms))
  names(big)<-bigNms
  (cpusPerHost=big)
  if (host=="tk1") cpusPerHost=cpusPerHost[1]
  if (host=="rnrClust") cpusPerHost=cpusPerHost[1:5]
#if (host=="dck") cpusPerHost=big
  if (host=="dNTP") cpusPerHost=c("localhost" = 3)
  if (host=="tk2") cpusPerHost=cpusPerHost[1:9]
  cpus=sum(cpusPerHost)
  hosts=names(cpusPerHost)
  strn=rep(hosts,times=cpusPerHost)
  cl <- makeCluster(strn, type=ptype, verbose=TRUE) # this one can work either way
#  print(clusterCall(cl, function() getwd()))
#  print(clusterCall(cl, function() Sys.info()[c("nodename","machine")]))
  clusterEvalQ(cl, require(PolynomF))
  clusterEvalQ(cl, require(odesolve))
  clusterEvalQ(cl, require(ccems))  # functions already all there from global library(ccems) in parent script
  clusterExport(cl,ls(.GlobalEnv))
  nG=clusterApplyLB(cl,G,fitModel)
  stopCluster(cl)
} 
if (ptype=="") nG=lapply(G,fitModel)

(tab=data.frame(id="XX",p=rep(0,6),SSE=0,AIC=0, 
          i1=0,i2=0,i3=0,#sig=0,AICc=0,AIC=0,AICchk=0,
          k0=0,k1=0,k2=0,k3=0,
          K0=0,K1=0,K2=0,K3=0
      ))
for (i in 1:length(nG)) {
  SSE=nG[[i]]$SSE$final
  AICc=signif(nG[[i]]$AIC$final,3) 
  p=sum(nG[[i]]$params[,"opt"])
  SSE=format(SSE,digits=3)
  vals=format(nG[[i]]$params[,"final"],digits=2,trim=T,scientific=FALSE)
  names(vals)<-row.names(nG[[i]]$params)
  tmp=c(id=nG[[i]]$id,p=p,SSE=SSE,AIC=AICc,vals)
  if (length(which(tab$id!="XX"))==0) jj=1 else jj=max(which(tab$id!="XX"))+1
  tab[jj,names(tmp)]=tmp
}
tab=tab[I<-order(tab$AIC,decreasing=TRUE),]
row.names(tab)<-1:dim(tab)[1]
tab[,c(1,3)]
nG=nG[I]
save(tab,nG,file=paste(home,"/results/nG.RData",sep=""))
#traceback()
