rm(list=ls(all=TRUE))  # clean up left overs from previous run, though shouldn't need to.
# This code is meant to be run on a ROCKS 5.1 cluster
if (.Platform$OS.type=="windows") home="/users/radivot" else home="/home/radivot"
source(paste(home,"/start.r",sep=""))  # define host="machineName" in this file
setwd(home)  # place where models and results will go
if (0) library(ccems) else { # if 0 source in the package 
  pkgNms=dir(paste(home,"/case/active/ccems/ccems/R",sep=""),full.names=TRUE)
  for (i in pkgNms) source(i)  # source in all of the R files of the package
  RNR=read.table(file=paste(home,"/case/active/rnr/datasets/RNR.txt",sep=""),header=TRUE)
}
d=subset(RNR,(year==2002)&(fg==7)&(C>0)&(v>0)&(X<3200),select=c(R,r,C,X,v,year))
if (!is.null(dev.list())) for (i in 2:max(dev.list())) dev.off(i);
d=transform(d,k=v)
names(d)[c(1,4)]=c("RT","XT")
dim(d)

d=d[order(d$XT),]
options(stringsAsFactors = FALSE)
library(PolynomF)
library(snow)
library(gafit)
source(paste(home,"/case/active/ccems/ccems/inst/papers/RXC/commonRXC.R",sep=""))

load("C:/Users/radivot/case/active/rnr/RXC/nG.RData")
#hist(as.numeric(tab$SSE))
#library(hwriter)
#hwrite(tab,"C:/Users/radivot/case/active/rnr/RXC/tab3.html",cellspacing=0,cellpadding=2)
nG[[270]]

fitModel(nG[[270]])


if (!is.null(dev.list())) for (i in 2:max(dev.list())) dev.off(i);
lapply(head(nG),plotg)

reportg<-function(g) {
  if (g$hess) {
    tmp=format(cbind(g$params[g$params$opt,"final",drop=F],g$CI),digits=2,trim=T,scientific=FALSE) 
    tmp=transform(tmp,Wald.95.CI=mapply(paste,"(",lower,", ",upper,")",sep=""))
    names(tmp)[1]<-c("Estimate")
    g$report=subset(tmp,select=c("Estimate","Wald.95.CI"))
  }
  g
}

nG=lapply(nG,reportg)

#cnt=0
#for (i1 in 1:5) 
#  for (i2 in (3*i1):17) 
#    for (i3 in (i2+1):18){
#      cnt=cnt+1
#    }
#cnt  # 270

